/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.report;

import cz.insophy.inplan.util.Localizer;
import java.util.Calendar;

public enum TimeWindow {
    DAY(Localizer.getString("report.timewindow.day"), 5, 1),
    WEEK(Localizer.getString("report.timewindow.week"), 5, 7),
    MONTH(Localizer.getString("report.timewindow.month"), 2, 1);

    private final String title;
    private final int calendarField;
    private final int windowSize;

    private TimeWindow(String title, int calendarField, int windowSize) {
        this.title = title;
        this.calendarField = calendarField;
        this.windowSize = windowSize;
    }

    public String toString() {
        return this.title;
    }

    public void pushCalendarInPlace(Calendar c, int n) {
        if (n == 0) {
            return;
        }
        c.add(this.calendarField, n * this.windowSize);
    }

    public Calendar pushCalendar(Calendar c, int n) {
        Calendar out = (Calendar)c.clone();
        this.pushCalendarInPlace(out, n);
        return out;
    }

    public long getEstimatedSize() {
        switch (this) {
            case DAY: {
                return 86400000L;
            }
            case WEEK: {
                return 604800000L;
            }
            case MONTH: {
                return 2592000000L;
            }
        }
        throw new IllegalStateException();
    }
}

